<?php

/*
Plugin Name: Events Addon for Elementor
Plugin URI: https://nicheaddons.com/demos/events
Description: Events Addon for Elementor covers all the must-needed elements for creating a perfect Event website using Elementor Page Builder. 30+ Unique & Basic Elementor widget covers all of the Event elements. Including getting a list of event posts from most popular Events WordPress plugins. Like, Accommodation, Venue, Conference, Event Timing Countdown, Organizer, Speakers, Schedules, Upcoming Events, and Tickets.
Author: NicheAddons
Author URI: https://nicheaddons.com/
Version: 2.3.0
Text Domain: events-addon-for-elementor
*/
include_once ABSPATH . 'wp-admin/includes/plugin.php';
/* PLUGIN SELF PATH */
define( 'NAEAFE_VERSION', '2.3.0' );
define( 'NAEAFE_URL', plugins_url( '/', __FILE__ ) );
// Freemius Code
if ( !function_exists( 'eafe_fs' ) ) {
    // Create a helper function for easy SDK access.
    function eafe_fs() {
        global $eafe_fs;
        if ( !isset( $eafe_fs ) ) {
            // Include Freemius SDK.
            require_once dirname( __FILE__ ) . '/freemius/start.php';
            $eafe_fs = fs_dynamic_init( array(
                'id'             => '6748',
                'slug'           => 'events-addon-for-elementor',
                'premium_slug'   => 'events-addon-for-elementor-pro',
                'type'           => 'plugin',
                'public_key'     => 'pk_1503d9f01649574d4ab8a44433148',
                'is_premium'     => false,
                'premium_suffix' => 'Pro',
                'has_addons'     => false,
                'has_paid_plans' => true,
                'menu'           => array(
                    'slug'           => 'naevents_admin_page',
                    'override_exact' => true,
                    'support'        => false,
                    'parent'         => array(
                        'slug' => 'naevents_admin_page',
                    ),
                ),
                'is_live'        => true,
            ) );
        }
        return $eafe_fs;
    }

    // Init Freemius.
    eafe_fs();
    // Signal that SDK was initiated.
    do_action( 'eafe_fs_loaded' );
    function eafe_fs_settings_url() {
        return admin_url( 'admin.php?page=naevents_admin_page' );
    }

    eafe_fs()->add_filter( 'connect_url', 'eafe_fs_settings_url' );
    eafe_fs()->add_filter( 'after_skip_url', 'eafe_fs_settings_url' );
    eafe_fs()->add_filter( 'after_connect_url', 'eafe_fs_settings_url' );
    eafe_fs()->add_filter( 'after_pending_connect_url', 'eafe_fs_settings_url' );
}
/**
 * Enqueue Files for BackEnd
 */
if ( !function_exists( 'naevents_admin_scripts_styles' ) ) {
    function naevents_admin_scripts_styles(  $hook  ) {
        if ( 'toplevel_page_naevents_admin_page' == $hook ) {
            wp_enqueue_style(
                'linea',
                plugins_url( '/', __FILE__ ) . 'assets/css/themify-icons.min.css',
                array(),
                '1.0.0',
                'all'
            );
        }
        wp_enqueue_style( 'naevents-admin-styles', plugins_url( '/', __FILE__ ) . 'assets/css/admin-styles.css', true );
        wp_enqueue_script(
            'naevents-admin-script',
            plugins_url( '/', __FILE__ ) . 'assets/js/admin-scripts.js',
            array('jquery'),
            '1.1',
            true
        );
    }

    add_action( 'admin_enqueue_scripts', 'naevents_admin_scripts_styles' );
}
// Admin Pages
require_once plugin_dir_path( __FILE__ ) . '/elementor/naevents-admin-functions.php';
require_once plugin_dir_path( __FILE__ ) . '/elementor/naevents-admin-page.php';
require_once plugin_dir_path( __FILE__ ) . '/elementor/naevents-admin-sub-page.php';
require_once plugin_dir_path( __FILE__ ) . '/elementor/naevents-admin-basic-fields.php';
// add_action( 'admin_init', 'eafe_bw_settings_init' );
require_once plugin_dir_path( __FILE__ ) . '/elementor/naevents-admin-unique-fields.php';
// add_action( 'admin_init', 'eafe_unqw_settings_init' );
require_once plugin_dir_path( __FILE__ ) . '/elementor/naevents-admin-pro-fields.php';
// add_action( 'admin_init', 'eafe_prow_settings_init' );
if ( !function_exists( 'naevents_admin_menu' ) ) {
    add_action( 'admin_menu', 'naevents_admin_menu' );
    function naevents_admin_menu() {
        add_menu_page(
            'Events Addon for Elementor',
            'Events Addon',
            'manage_options',
            'naevents_admin_page',
            'naevents_admin_sub_page',
            'dashicons-carrot',
            80
        );
    }

}
// ABSPATH
if ( !function_exists( 'naevents_block_direct_access' ) ) {
    function naevents_block_direct_access() {
        if ( !defined( 'ABSPATH' ) ) {
            exit( 'Forbidden' );
        }
    }

}
// Initial File
require_once plugin_dir_path( __FILE__ ) . '/elementor/em-setup.php';
// Plugin language
if ( !function_exists( 'naevents_plugin_language_setup' ) ) {
    function naevents_plugin_language_setup() {
        load_plugin_textdomain( 'events-addon-for-elementor', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    }

    add_action( 'init', 'naevents_plugin_language_setup' );
}
// Check if Elementor installed and activated
if ( !function_exists( 'naevents_load_plugin' ) ) {
    function naevents_load_plugin() {
        if ( !did_action( 'elementor/loaded' ) ) {
            add_action( 'admin_notices', 'admin_notice_missing_main_plugin' );
            return;
        }
    }

    add_action( 'plugins_loaded', 'naevents_load_plugin' );
}
// Warning when the site doesn't have Elementor installed or activated.
if ( !function_exists( 'admin_notice_missing_main_plugin' ) ) {
    function admin_notice_missing_main_plugin() {
        if ( isset( $_GET['activate'] ) ) {
            unset($_GET['activate']);
        }
        $message = sprintf( 
            /* translators: 1: Plugin name 2: Elementor */
            esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'events-addon-for-elementor' ),
            '<strong>' . esc_html__( 'Events Addon for Elementor', 'events-addon-for-elementor' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'events-addon-for-elementor' ) . '</strong>'
         );
        printf( '<div class="notice notice-error is-dismissible"><p>%1$s</p></div>', $message );
    }

}
// Both Free and Pro activated
if ( is_plugin_active( 'events-addon-for-elementor/events-addon-for-elementor.php' ) && is_plugin_active( 'events-addon-for-elementor-pro/events-addon-for-elementor.php' ) ) {
    add_action( 'admin_notices', 'admin_notice_deactivate_free' );
}
// Warning when the site have Both Free and Pro activated.
if ( !function_exists( 'admin_notice_deactivate_free' ) ) {
    function admin_notice_deactivate_free() {
        if ( isset( $_GET['activate'] ) ) {
            unset($_GET['activate']);
        }
        $message = sprintf( 
            /* translators: 1: Plugin name */
            esc_html__( 'Please deactivate the free version of "%1$s".', 'events-addon-for-elementor' ),
            '<strong>' . esc_html__( 'Events Addon for Elementor', 'events-addon-for-elementor' ) . '</strong>'
         );
        printf( '<div class="notice notice-error is-dismissible"><p>%1$s</p></div>', $message );
    }

}
// Enable & Dissable Notice
add_action( 'admin_notices', 'admin_notice_enable_dissable' );
if ( !function_exists( 'admin_notice_enable_dissable' ) ) {
    function admin_notice_enable_dissable() {
        if ( isset( $_GET['settings-updated'] ) ) {
            $message = sprintf( esc_html__( 'Widgets Settings Saved.', 'events-addon-for-elementor' ) );
            printf( '<div class="notice notice-success is-dismissible"><p>%1$s</p></div>', $message );
        }
    }

}
// Enqueue Files for Elementor Editor
if ( is_plugin_active( 'elementor/elementor.php' ) ) {
    // Css Enqueue
    add_action( 'elementor/editor/before_enqueue_scripts', function () {
        wp_enqueue_style(
            'naevents-ele-editor-linea',
            plugins_url( '/', __FILE__ ) . 'assets/css/linea.min.css',
            [],
            '1.0.0'
        );
        wp_enqueue_style(
            'naevents-ele-editor-themify',
            plugins_url( '/', __FILE__ ) . 'assets/css/themify-icons.min.css',
            [],
            '1.0.0'
        );
    } );
    // Js Enqueue
    add_action( 'elementor/frontend/after_enqueue_scripts', function () {
        wp_enqueue_script(
            'naevents-chartjs',
            plugins_url( '/', __FILE__ ) . 'assets/js/Chart.min.js',
            array('jquery'),
            '2.6.0',
            true
        );
    } );
}
// Enqueue Files for FrontEnd
if ( !function_exists( 'naevents_scripts_styles' ) ) {
    function naevents_scripts_styles() {
        // Styles
        wp_enqueue_style(
            'niche-frame',
            plugins_url( '/', __FILE__ ) . 'assets/css/niche-frame.css',
            array(),
            '1.0',
            'all'
        );
        wp_enqueue_style(
            'font-awesome',
            plugins_url( '/', __FILE__ ) . 'assets/css/font-awesome.min.css',
            array(),
            '4.7.0',
            'all'
        );
        wp_enqueue_style(
            'animate',
            plugins_url( '/', __FILE__ ) . 'assets/css/animate.min.css',
            array(),
            '3.7.2',
            'all'
        );
        wp_enqueue_style(
            'themify-icons',
            plugins_url( '/', __FILE__ ) . 'assets/css/themify-icons.min.css',
            array(),
            '1.0.0',
            'all'
        );
        wp_enqueue_style(
            'linea',
            plugins_url( '/', __FILE__ ) . 'assets/css/linea.min.css',
            array(),
            '1.0.0',
            'all'
        );
        wp_enqueue_style(
            'magnific-popup',
            plugins_url( '/', __FILE__ ) . 'assets/css/magnific-popup.min.css',
            array(),
            '1.0',
            'all'
        );
        wp_enqueue_style(
            'owl-carousel',
            plugins_url( '/', __FILE__ ) . 'assets/css/owl.carousel.min.css',
            array(),
            '2.3.4',
            'all'
        );
        wp_enqueue_style(
            'juxtapose',
            plugins_url( '/', __FILE__ ) . 'assets/css/juxtapose.css',
            array(),
            '1.0',
            'all'
        );
        wp_enqueue_style(
            'naevents-styles',
            plugins_url( '/', __FILE__ ) . 'assets/css/styles.css',
            array(),
            '1.8.2',
            'all'
        );
        wp_enqueue_style(
            'naevents-responsive',
            plugins_url( '/', __FILE__ ) . 'assets/css/responsive.css',
            array(),
            '1.8.2',
            'all'
        );
        // Scripts
        wp_enqueue_script(
            'imagesloaded',
            plugins_url( '/', __FILE__ ) . 'assets/js/imagesloaded.pkgd.min.js',
            array('jquery'),
            '4.1.4',
            true
        );
        wp_enqueue_script(
            'magnific-popup',
            plugins_url( '/', __FILE__ ) . 'assets/js/jquery.magnific-popup.min.js',
            array('jquery'),
            '1.1.0',
            true
        );
        wp_enqueue_script(
            'juxtapose',
            plugins_url( '/', __FILE__ ) . 'assets/js/juxtapose.js',
            array('jquery'),
            '1.1.2',
            true
        );
        wp_enqueue_script(
            'typed',
            plugins_url( '/', __FILE__ ) . 'assets/js/typed.min.js',
            array('jquery'),
            '2.0.11',
            true
        );
        wp_enqueue_script(
            'owl-carousel',
            plugins_url( '/', __FILE__ ) . 'assets/js/owl.carousel.min.js',
            array('jquery'),
            '2.3.4',
            true
        );
        wp_enqueue_script(
            'countdown',
            plugins_url( '/', __FILE__ ) . 'assets/js/jquery.countdown.min.js',
            array('jquery'),
            '1.6.2',
            true
        );
        wp_enqueue_script(
            'matchheight',
            plugins_url( '/', __FILE__ ) . 'assets/js/jquery.matchHeight.min.js',
            array('jquery'),
            '0.7.2',
            true
        );
        wp_enqueue_script(
            'isotope',
            plugins_url( '/', __FILE__ ) . 'assets/js/isotope.min.js',
            array('jquery'),
            '3.0.1',
            true
        );
        wp_enqueue_script(
            'packery-mode',
            plugins_url( '/', __FILE__ ) . 'assets/js/packery-mode.pkgd.min.js',
            array('jquery'),
            '2.0.1',
            true
        );
        wp_enqueue_script(
            'theia-sticky',
            plugins_url( '/', __FILE__ ) . 'assets/js/theia-sticky-sidebar.min.js',
            array('jquery'),
            '1.8.2',
            true
        );
        wp_enqueue_script(
            'naevents-scripts',
            plugins_url( '/', __FILE__ ) . 'assets/js/scripts.js',
            array('jquery'),
            '1.8.2',
            true
        );
    }

    add_action( 'wp_enqueue_scripts', 'naevents_scripts_styles' );
}
// is_premium